function [info] = runprob(pname, lambda)
%====================================================================
% Purpose : Solve a test problem using the solver.
%====================================================================
%
% Input:
%    pname: name of the problem being solving. 
%====================================================================

dir = '../datasets/libsvm/';
%dir = 'D:/Data/';

%Load the problem
probLoad = sprintf([dir,pname,'.mat']);
load(probLoad);

%Load parameter settings
parms = adahspsvrg_fp_mixed_l1l2_spec;
parms.batch_size = min([256 * 100000, floor(0.01 * size(X, 1))]);
% parms.batch_size = min([256, floor(0.01 * size(X, 1))]);

norm_square_samples = vecnorm(X') .^ 2;
L = max(norm_square_samples) / 4.0;
parms.alpha = 1.0 / L; 

% Choose weighting parameter, set objective function.
%lambda = 100/size(X,1); % Need to look into this.
groups = split_groups_new(size(X, 2), parms.num_groups);

lambda = lambda;
m = size(X, 1);
n = size(X, 2);

% Get the lossfunction by X,y.
funObj = lossfunction.LogRegCost(X,y);
% Solve the problem.

        
info = adahspsvrg_fp_mixed_l1l2_solver(pname,funObj,lambda,parms);
save([pname, '_', lambda, '.x.mat'], info.x);
%info.x'
funObj.setExpterm(info.x, 1:m);
funObj.setSigmoid();
f = funObj.func(1:m); 

size(X)
size(y)

% test if applicable
test_dir = '../datasets/libsvm/tests/';
for i = 1 : 4
    testDataLoad = sprintf([test_dir,pname,'.t.', int2str(i), '.mat']);
    load(testDataLoad);
    X_test = X;
    y_test = y;
    % y_test
    accuracy = test(n, info.x, X_test, y_test);

    info.accuracy = accuracy;
    accuracy
end

end

function [accuracy] = test(n, w, X, y)
    if size(X, 2) < n
        paddings = zeros(size(X, 1), n - size(X, 2));
        X = [X, paddings];
    end  
    w_only = w(1: n, 1);
    wTxPb = 0;
    if size(w, 1) > n
        bias = w(n + 1, 1);
        wTxPb = X * w_only + bias;
    else
        wTxPb = X * w_only;
    end
    y(y > 0) = 1;
    y(y <=0) = 0;
    size(y)
    correct_pos_num = 0;
    correct_neg_num = 0;
    for i = 1 : size(y, 1)
        pred_prob = 1.0 / (1.0 + exp(-wTxPb(i, 1)));
        if pred_prob > 0.5 && y(i) == 1
            correct_pos_num = correct_pos_num + 1;
        elseif pred_prob <= 0.5 && y(i) == 0
            correct_neg_num = correct_neg_num + 1;
        end
    end
    accuracy = (correct_pos_num + correct_neg_num) / size(y, 1);
end
